#import <Foundation/Foundation.h>

@interface MyClass : NSObject
@property (copy) NSString *copiedString; // strong
@property (assign) NSString *assignedString;  // weak
@end
@implementation MyClass
@end

int main(int argc, const char * argv[])
{
    @autoreleasepool
    {
        MyClass *myObj = [MyClass new];
        
        NSMutableString *val = [NSMutableString stringWithString: @"Default"];
        myObj.copiedString = myObj.assignedString = val;
        
        [val appendString: @" and some new things"];
        
        
        NSLog(@"Copied is: %@", myObj.copiedString);
        NSLog(@"Assigned is: %@", myObj.assignedString);
    }
    return 0;
}
